var flipShown = false; 
var animation = {duration:0, starttime:0, to:1.0, now:0.0, from:0.0,  firstElement:null, timer:null}; 

if (window.widget) {
	window.widget.onshow   = onshow;
	window.widget.onhide   = onhide;
	window.widget.onremove = onremove;
}

var pin;
var gauge;
var net_dish;
var diskRead;
var diskWrite;

var lastDiskReadRotation = 0;
var lastDiskWriteRotation = 0;

var regDisplayed = 0;

function setup() {
	//alert("In setup()");

	document.getElementById('front').style.display = "block";
	document.getElementById('back').style.display = "none";
	document.getElementById("reg_cell").style.display = "none";     
	document.getElementById("reg_separator").style.display = "none";     
	
	// Set up the images that we will use later in the canvases.
	// Net
	net_dish = new Image(75,100);
	net_dish.src = "Themes/Default/satellite.png";

	// Net images that we want to load into the cache (but won't be used here).
	var tmp_net = new Image(81, 68);
	tmp_net.src = "Themes/Default/net_right_0.png";
	tmp_net.src = "Themes/Default/net_right_1.png";
	tmp_net.src = "Themes/Default/net_right_2.png";
	tmp_net.src = "Themes/Default/net_right_3.png";
	tmp_net.src = "Themes/Default/net_right_4.png";
	tmp_net.src = "Themes/Default/net_right_5.png";
	tmp_net.src = "Themes/Default/net_right_6.png";
	tmp_net.src = "Themes/Default/net_right_7.png";
	tmp_net.src = "Themes/Default/net_right_8.png";
	tmp_net.src = "Themes/Default/net_left_0.png";
	tmp_net.src = "Themes/Default/net_left_1.png";
	tmp_net.src = "Themes/Default/net_left_2.png";
	tmp_net.src = "Themes/Default/net_left_3.png";
	tmp_net.src = "Themes/Default/net_left_4.png";
	tmp_net.src = "Themes/Default/net_left_5.png";
	tmp_net.src = "Themes/Default/net_left_6.png";
	tmp_net.src = "Themes/Default/net_left_7.png";
	tmp_net.src = "Themes/Default/net_left_8.png";
	
	// Disk
	diskRead = new Image(100, 100);
	diskRead.src = "Themes/Default/diskread.png";
	diskWrite = new Image(100, 100);
	diskWrite.src = "Themes/Default/diskwrite.png";

	lastDiskReadRotation = 0;
	lastDiskWriteRotation = 0;

	// Display the modules
	setMonitorsDisplayFromPrefs();

	setNumCPUs();
	
	updateDisplay();
	updateText();
	slowUpdate();

	if (DMController) {
		if (!DMController.allowUsage) {
			registerGo(true);
		}
	}

	return 0;
}

function setNumCPUs() {
	//alert("In setNumCPUs()");

	if (DMController) {
		// Show the second CPU if necessary
		if (DMController.cpu2Percentage == -1) {
			document.getElementById('GRAPHICcpu_1').style.display = "block";
			document.getElementById('GRAPHICcpu_2').style.display = "none";
			document.getElementById('TEXTcpu_2').style.display = "none";
			document.getElementById('TEXTcpu1Label').innerHTML = "CPU:";
		}
		else {
			document.getElementById('GRAPHICcpu_1').style.display = "none";
			document.getElementById('GRAPHICcpu_2').style.display = "block";

			document.getElementById('TEXTcpu1Label').innerHTML = "CPU 1:";
			document.getElementById('TEXTcpu_2').style.display = "";
		}
	}

	return;
}

function savePrefs() {
	//alert("In savePrefs()");

	var cpuBox = document.getElementById("cpu_mode");
	var cpuEnable = document.getElementById("cpu_enable");
	changeMode("cpu", cpuEnable, cpuBox);
	
	var memBox = document.getElementById("mem_mode");
	var memEnable = document.getElementById("mem_enable");
	changeMode("mem", memEnable, memBox);
	
	var netBox = document.getElementById("net_mode");
	var netEnable = document.getElementById("net_enable");
	changeMode("net", netEnable, netBox);
	
	var diskBox = document.getElementById("disk_mode");
	var diskEnable = document.getElementById("disk_enable");
	changeMode("disk", diskEnable, diskBox);

	setMonitorsDisplayFromPrefs();
}

function changeMode(monitorName, enableBox, selectBox) {
	//alert("In changeMode()");

	// Save the changes in our prefs.
	if (window.widget) {
		window.widget.setPreferenceForKey(enableBox.checked.toString(), createkey(monitorName + "_enable"));
		window.widget.setPreferenceForKey(selectBox.selectedIndex.toString(), createkey(monitorName + "_mode"));
	}
}

function setMonitorsDisplayFromPrefs() {
	//alert("In setMonitorsDisplayFromPrefs()");

	setMonitorFromPrefs("cpu");	
	setMonitorFromPrefs("mem");	
	setMonitorFromPrefs("net");	
	setMonitorFromPrefs("disk");	
}

function setMonitorFromPrefs(monitorName) {
	//alert("In setMonitorFromPrefs()");

	if (window.widget) {
		var enabled = window.widget.preferenceForKey(createkey(monitorName + "_enable"));
		var mode = parseInt(window.widget.preferenceForKey(createkey(monitorName + "_mode")));

		if (enabled == "false") {
			hideSection(monitorName + "_text");
			hideSection(monitorName + "_simple");
			hideSection(monitorName + "_graphic");
			return;
		}

		if (mode == 0) {
			showSection(monitorName + "_text");
			hideSection(monitorName + "_simple");
			hideSection(monitorName + "_graphic");
		}
		else if (mode == 1) {
			hideSection(monitorName + "_text");
			showSection(monitorName + "_simple");
			hideSection(monitorName + "_graphic");
		}
		else if (mode == 2) {
			hideSection(monitorName + "_text");
			hideSection(monitorName + "_simple");
			showSection(monitorName + "_graphic");
		}
		else {
			hideSection(monitorName + "_text");
			hideSection(monitorName + "_simple");
			showSection(monitorName + "_graphic");
		}
	}	
	else {
			hideSection(monitorName + "_text");
			hideSection(monitorName + "_simple");
			showSection(monitorName + "_graphic");
	}
}

function updateDisplay() {
	//alert("In updateDisplay()");

//	if (window.widget) {
//		widget.resizeTo(540, 500);
//	}
	
	if (DMController) {
		setCPUGraphPercent(DMController.cpu1Percentage, 
		                   DMController.cpu2Percentage);
	
		setNetPercent(DMController.netRXBytes, 
		              DMController.netTXBytes, 
		              DMController.netMaxBytes);
	
		setDiskPercent(DMController.diskReadBytes, 
		               DMController.diskWriteBytes,
		               DMController.diskMaxBytes);
	}
}

function updateText() {
	//alert("In updateText()");

	if (DMController) {
		setMemPercent(DMController.wiredMemory,
		              DMController.activeMemory,
		              DMController.inactiveMemory,
		              DMController.freeMemory);


		setNetText(DMController.netRXBytes, 
		           DMController.netTXBytes); 
		
		setDiskText(DMController.diskReadBytes, 
		            DMController.diskWriteBytes);
	}
}

function slowUpdate() {
	//alert("In slowUpdate()");

	if (DMController) {
		setCPUText(DMController.cpu1Percentage,
		           DMController.cpu2Percentage);

		setMemText(DMController.wiredMemory,
		           DMController.activeMemory,
		           DMController.inactiveMemory,
		           DMController.freeMemory);
	}
}

function setCPUGraphPercent(percent1, percent2) {
	//alert("In setCPUGraphPercent()");

	document.getElementById('SIMPLEcpu1Pos').width = percent1 + "%";

	if (percent2 == -1) 
		document.getElementById('SIMPLEcpu2Pos').width = percent1 + "%";
	else 
		document.getElementById('SIMPLEcpu2Pos').width = percent2 + "%";
			


	percent1 = Math.round(percent1 / 2) * 2;
	if (percent1 > 100) percent1 = 100;
	document.getElementById('cpu_1_gauge').src = "Themes/Default/pins/pin" + percent1 + ".png";
	document.getElementById('2cpu_1_gauge').src = "Themes/Default/pins/pin" + percent1 + ".png";

	if (percent2 != -1) {
		percent2 = Math.round(percent2 / 2) * 2;
		if (percent2 > 100) percent2 = 100;
		document.getElementById('2cpu_2_gauge').src = "Themes/Default/pins/pin" + percent2 + ".png";
	}
	return;

	var canvas = document.getElementById("GRAPHICcpu_canvas");
	var context = canvas.getContext("2d");

	context.clearRect(0, 0, 205, 100);

	if (percent2 == -1) {	
		context.save();

		try {
			context.translate(65, 0);							// Move so our gauge is in the middle.
			context.drawImage(gauge, 0, 0, 100, 100);		// Draw the gauge.

			context.translate(100 / 2, 100 / 2);			// Move our origin to the middle of the gauge for the rotation.
	
			context.rotate(getRotationForCPUPercent(percent1));	// Rotate the canvas to draw the pin.
			context.translate(-8, -44);
			context.drawImage(pin, 0, 0, 15, 51);
		
		}
		catch (e) {
			//alert("Dash Monitors: Caught an exception.  Not to worry though...");
		}

		context.restore();
	}
	else {	

		context.save();
		
		try {
//			context.translate(100 / 2, 100 / 2);	// Move our origin to the middle of the 1st gauge for the rotation.
	
//			context.rotate(getRotationForCPUPercent(percent1));
//			context.translate(-8, -44);
//			context.drawImage(pin, 0, 0, 15, 51);
			
			percent1 = Math.round(percent1 / 2);
			percent1 *= 2;
			if (percent1 > 100) percent1 = 100;
			var pinImage = new Image(100, 100);
			pinImage.src = "Themes/Default/pins/pin" + percent1 + ".png";
			document.getElementById('cpu_1_gauge').src = "Themes/Default/pins/pin" + percent1 + ".png";
		
			context.drawImage(gauge, 0, 0, 100, 100);
			context.drawImage(pinImage, 0, 0, 100, 100);
		}
		catch (e) {
			//alert("Dash Monitors: Caught an exception.  Not to worry though...");
		}

		context.restore();

		context.save();

		try {
			context.translate(105, 0);
			
			percent2 = Math.round(percent2 / 2);
			percent2 *= 2;
			if (percent2 > 100) percent2 = 100;
			pinImage = new Image(100, 100);
			pinImage.src = "Themes/Default/pins/pin" + percent2 + ".png";
			
			context.drawImage(gauge, 0, 0, 100, 100);
			context.drawImage(pinImage, 0, 0, 100, 100);
	
			// Translate so our origin is in the middle of the canvas, in order to do correct rotations.
			//context.translate(100 / 2, 100 / 2);
	
			//context.rotate(getRotationForCPUPercent(percent2));
			//context.translate(-8, -44);
			//context.drawImage(pin, 0, 0, 15, 51);
		}
		catch (e) {
			//alert("Dash Monitors: Caught an exception.  Not to worry though...");
		}
			
		context.restore();
	}
}

function getRotationForCPUPercent(percent) {
	//alert("In getRotationForCPUPercent()");

	return (-240 + 90 + (percent * 3)) / 180 * 3.1415;
}
	
function setCPUText(percent1, percent2) {
	//alert("In setCPUText()");

	if (percent2 == -1) {
		document.getElementById('TEXTcpu1Text').innerHTML = parseInt(percent1) + "%";

		document.getElementById('SIMPLEcpuTextRight').innerHTML = parseInt(percent1) + "%";
		document.getElementById('SIMPLEcpuTextLeft').innerHTML = "";
	}
	else {
		document.getElementById('TEXTcpu1Text').innerHTML = parseInt(percent1) + "%";
		document.getElementById('TEXTcpu2Text').innerHTML = parseInt(percent2) + "%";

		document.getElementById('SIMPLEcpuTextLeft').innerHTML = parseInt(percent1) + "%";
		document.getElementById('SIMPLEcpuTextRight').innerHTML = parseInt(percent2) + "%";
	}

	/*
	if (window.widget) {
		var obj = widget.system('ps -arcx -o %cpu,command | head -4', null);

		document.getElementById('TEXTtopCPUProcs').innerHTML = "<pre> " + obj.outputString + "</pre>";
	}
	*/
}

var lastWiredPercent = 0;
var lastActivePercent = 0;
var lastInactivePercent = 0;
var lastFreePercent = 0;
function setMemPercent(wired, active, inactive, free) {
	//alert("In setMemPercent()");

	var total = wired + active + inactive + free;
	var tmpWired = Math.round(wired / total * 100);
	var tmpActive = Math.round(active / total * 100);
	var tmpInactive = Math.round(inactive / total * 100);
	var tmpFree = Math.round(free / total * 100);

	if (lastWiredPercent - tmpWired > 1 || tmpWired - lastWiredPercent > 1 || lastActivePercent - tmpActive > 1 || tmpActive - lastActivePercent > 1 || lastInactivePercent - tmpInactive > 1 || tmpInactive - lastInactivePercent > 1 || lastFreePercent - tmpFree > 1 || tmpFree - lastFreePercent > 1) 
	{
		document.getElementById('GRAPHICmemWired').width    = tmpWired + "%";
		document.getElementById('SIMPLEmemWired').width     = tmpWired + "%";
		document.getElementById('SIMPLEmemWiredText').width = tmpWired + "%";
		document.getElementById('GRAPHICmemWiredText').width = tmpWired + "%";
	
		document.getElementById('GRAPHICmemActive').width    = tmpActive + "%";
		document.getElementById('SIMPLEmemActive').width     = tmpActive + "%";
		document.getElementById('SIMPLEmemActiveText').width = tmpActive + "%";
		document.getElementById('GRAPHICmemActiveText').width = tmpActive + "%";
		
		document.getElementById('GRAPHICmemInactive').width    = tmpInactive + "%";
		document.getElementById('SIMPLEmemInactive').width     = tmpInactive + "%";
		document.getElementById('SIMPLEmemInactiveText').width = tmpInactive + "%";
		document.getElementById('GRAPHICmemInactiveText').width = tmpInactive + "%";
		
		document.getElementById('GRAPHICmemFree').width    = "100%";
		document.getElementById('SIMPLEmemFree').width     = tmpFree + "%";
		document.getElementById('SIMPLEmemFreeText').width = tmpFree + "%";
		document.getElementById('GRAPHICmemFreeText').width = tmpFree + "%";
	}

	setMemText(wired, active, inactive, free);
}

function setMemText(wired, active, inactive, free) {
	//alert("In setMemText()");

	var wiredString    = parseInt(wired / 1024) + "M";
	var activeString   = parseInt(active / 1024) + "M";
	var inactiveString = parseInt(inactive / 1024) + "M";
	var freeString     = parseInt(free / 1024) + "M";
	
	document.getElementById('TEXTmemWiredText').innerHTML    = wiredString;
	document.getElementById('TEXTmemActiveText').innerHTML   = activeString;
	document.getElementById('TEXTmemInactiveText').innerHTML = inactiveString;
	document.getElementById('TEXTmemFreeText').innerHTML     = freeString;

	document.getElementById('SIMPLEmemWiredText').innerHTML    = wiredString;
	document.getElementById('SIMPLEmemActiveText').innerHTML   = activeString;
	document.getElementById('SIMPLEmemInactiveText').innerHTML = inactiveString;
	document.getElementById('SIMPLEmemFreeText').innerHTML     = freeString;

	document.getElementById('GRAPHICmemWiredText').innerHTML    = wiredString;
	document.getElementById('GRAPHICmemActiveText').innerHTML   = activeString;
	document.getElementById('GRAPHICmemInactiveText').innerHTML = inactiveString;
	document.getElementById('GRAPHICmemFreeText').innerHTML     = freeString;

	/*
	if (window.widget) {
		var obj = widget.system('ps -amcx -o %mem,command | head -4', null);
		document.getElementById('TEXTtopMemProcs').innerHTML = "<pre>" + obj.outputString + "</pre>";
	}
	*/

}

function setNetPercent(rx, tx, max) {
	//alert("In setNetPercent()");

	var rxPercent = rx / max * 100;
	var txPercent = tx / max * 100;
	document.getElementById('net1Pos').width = rxPercent + "%";
	document.getElementById('net1Neg').width = "100%";
	
	document.getElementById('net2Pos').width = txPercent + "%";
	document.getElementById('net2Neg').width = "100%";

	setNetGraphRXTX(rx, tx, max);
}

function setNetText(rx, tx) {
	//alert("In setNetText()");

	if (rx > 1024 * 1024) {
		document.getElementById('netRXText').innerHTML = "<font color='#CE80FF'>RX</font>: " + parseInt(rx / 1024 / 1024) + "MB/sec";
		document.getElementById('netRText').innerHTML = parseInt(rx / 1024 / 1024) + "MB/sec";
		document.getElementById('netGraphicRX').innerHTML = "<b><font color='#CE80FF'>RX</font>:</b> " + parseInt(rx / 1024 / 1024) + "MB/sec";
	}
	else if (rx > 1024) {
		document.getElementById('netRXText').innerHTML = "<font color='#CE80FF'>RX</font>: " + parseInt(rx / 1024) + "KB/sec";
		document.getElementById('netRText').innerHTML = parseInt(rx / 1024) + "KB/sec";
		document.getElementById('netGraphicRX').innerHTML = "<b><font color='#CE80FF'>RX</font>:</b> " + parseInt(rx / 1024) + "KB/sec";
	}
	else {
		document.getElementById('netRXText').innerHTML = "<font color='#CE80FF'>RX</font>: " + parseInt(rx) + "B/sec";
		document.getElementById('netRText').innerHTML = parseInt(rx) + "B/sec";
		document.getElementById('netGraphicRX').innerHTML = "<b><font color='#CE80FF'>RX</font>:</b> " + parseInt(rx) + "B/sec";
	}
	
	if (tx > 1024 * 1024) {
		document.getElementById('netTXText').innerHTML = "<font color='#F8F522'>TX</font>: " + parseInt(tx / 1024 / 1024) + "MB/sec";
		document.getElementById('netTText').innerHTML = parseInt(tx / 1024 / 1024) + "MB/sec";
		document.getElementById('netGraphicTX').innerHTML = "<b><font color='#F8F522'>TX</font>:</b> " + parseInt(tx / 1024 / 1024) + "MB/sec";
	}
	else if (tx > 1024) {
		document.getElementById('netTXText').innerHTML = "<font color='#F8F522'>TX</font>: " + parseInt(tx / 1024) + "KB/sec";
		document.getElementById('netTText').innerHTML = parseInt(tx / 1024) + "KB/sec";
		document.getElementById('netGraphicTX').innerHTML = "<b><font color='#F8F522'>TX</font>:</b> " + parseInt(tx / 1024) + "KB/sec";
	}
	else {
		document.getElementById('netTXText').innerHTML = "<font color='#F8F522'>TX</font>: " + parseInt(tx) + "B/sec";
		document.getElementById('netTText').innerHTML = parseInt(tx) + "B/sec";
		document.getElementById('netGraphicTX').innerHTML = "<b><font color='#F8F522'>TX</font>:</b> " + parseInt(tx) + "B/sec";
	}
}

function setNetGraphRXTX(rx, tx, max) {
	//alert("In setNetGraphRXTX()");

	var canvas = document.getElementById("GRAPHICnet_canvas");
	var context = canvas.getContext("2d");

	// Figure out what net_right and net_left should be.
	var net_right = new Image(81, 68);
	imageNumber = Math.ceil(rx / max * 8);
	if (imageNumber < 0) imageNumber = 0;
	if (imageNumber > 8) imageNumber = 8;
	net_right.src = "Themes/Default/net_right_" + imageNumber + ".png";

	var net_left = new Image(81, 68);
	imageNumber = Math.ceil(tx / max * 8);
	if (imageNumber < 0) imageNumber = 0;
	if (imageNumber > 8) imageNumber = 8;
	net_left.src = "Themes/Default/net_left_" + imageNumber + ".png";

	context.clearRect(0, 0, 120, 125);
	//context.fillRect(0, 0, 120, 125);
	context.drawImage(net_dish, 0, 18, 58, 97);
	
	context.save();
	// Translate so our origin is in the middle of the dish.
	context.translate(38, 61);
	context.rotate(-288.5 / 180 * 3.1415926);
	context.translate(-40, -22);

	context.drawImage(net_right, 0, -56, 81, 68);
	context.drawImage(net_left, 0, -56, 81, 68);

	context.restore();
}

function setDiskPercent(read, write, max) {
	//alert("In setDiskPercent()");

	var readPercent = read / max * 100;
	var writePercent = write / max * 100;

	document.getElementById('disk1Pos').width = readPercent + "%";
	document.getElementById('disk2Pos').width = writePercent + "%";

	setDiskGraph(read, write, max);
}
	
function setDiskText(read, write) {
	//alert("In setDiskText()");

	if (read > 1024 * 1024) {
		document.getElementById('diskReadText').innerHTML = "<font color='#F8F522'>Read</font>: " + parseInt(read / 1024 / 1024) + "MB/sec";
		document.getElementById('diskRText').innerHTML = parseInt(read / 1024 / 1024) + "MB/sec";
		document.getElementById('diskGraphicRead').innerHTML = "Read: " + parseInt(read / 1024 / 1024) + "MB/sec";
	}
	else if (read > 1024) {
		document.getElementById('diskReadText').innerHTML = "<font color='#F8F522'>Read</font>: " + parseInt(read / 1024) + "KB/sec";
		document.getElementById('diskRText').innerHTML = parseInt(read / 1024) + "KB/sec";
		document.getElementById('diskGraphicRead').innerHTML = "Read: " + parseInt(read / 1024) + "KB/sec";
	}
	else {
		document.getElementById('diskReadText').innerHTML = "<font color='#F8F522'>Read</font>: " + parseInt(read) + "B/sec";
		document.getElementById('diskRText').innerHTML = parseInt(read) + "B/sec";
		document.getElementById('diskGraphicRead').innerHTML = "Read: " + parseInt(read) + "B/sec";
	}
	
	
	if (write > 1024 * 1024) {
		document.getElementById('diskWriteText').innerHTML = "<font color='#CE80FF'>Write</font>: " + parseInt(write / 1024 / 1024) + "MB/sec";
		document.getElementById('diskWText').innerHTML = parseInt(write / 1024 / 1024) + "MB/sec";
		document.getElementById('diskGraphicWrite').innerHTML = "Write: " + parseInt(write / 1024 / 1024) + "MB/sec";
	}
	else if (write > 1024) {
		document.getElementById('diskWriteText').innerHTML = "<font color='#CE80FF'>Write</font>: " + parseInt(write / 1024) + "KB/sec";
		document.getElementById('diskWText').innerHTML = parseInt(write / 1024) + "KB/sec";
		document.getElementById('diskGraphicWrite').innerHTML = "Write: " + parseInt(write / 1024) + "KB/sec";
	}
	else {
		document.getElementById('diskWriteText').innerHTML = "<font color='#CE80FF'>Write</font>: " + parseInt(write) + "B/sec";
		document.getElementById('diskWText').innerHTML = parseInt(write) + "B/sec";
		document.getElementById('diskGraphicWrite').innerHTML = "Write: " + parseInt(write) + "B/sec";
	}
}

function setDiskGraph(read, write, max) {
	//alert("In setDiskGraph()");

	var canvas1 = document.getElementById("GRAPHICdisk_read_canvas");
	var context1 = canvas1.getContext("2d");
	var c;

	context1.clearRect(0, 0, 120, 120);

	context1.save();
	// Translate so our origin is in the middle of the disk.
	context1.translate(50, 50);

	if (!lastDiskReadRotation) lastDiskReadRotation = 0;
	if (!lastDiskWriteRotation) lastDiskWriteRotation = 0;

	if (read > 100 * 1024 * 1024) {
		c = 1000 * 1024 * 1024;
	}
	else if (read > 10 * 1024 * 1024) {
		c = 100 * 1024 * 1024;
	}
	else if (read > 1 * 1024 * 1024) {
		c = 10 * 1024 * 1024;
	}
	else {
		c = 1 * 1024 * 1024;
	}

	lastDiskReadRotation += read / c * (3.1415 / 2);
	lastDiskReadRotation %= 2 * (3.1415 / 2);

	context1.rotate(lastDiskReadRotation);
	context1.drawImage(diskRead, -50, -50, 100, 100);
	context1.restore();

		
	var canvas2 = document.getElementById("GRAPHICdisk_write_canvas");
	var context2 = canvas2.getContext("2d");

	context2.clearRect(0, 0, 120, 120);

	context2.save();
	// Translate so our origin is in the middle of the disk.
	context2.translate(50, 50);

	if (write > 100 * 1024 * 1024) {
		c = 1000 * 1024 * 1024;
	}
	else if (write > 10 * 1024 * 1024) {
		c = 100 * 1024 * 1024;
	}
	else if (write > 1 * 1024 * 1024) {
		c = 10 * 1024 * 1024;
	}
	else {
		c = 1 * 1024 * 1024;
	}

	lastDiskWriteRotation += write / c * (3.1415 / 2);
	lastDiskWriteRotation %= 2 * (3.1415 / 2);

	context2.rotate(lastDiskWriteRotation);
	context2.drawImage(diskWrite, -50, -50, 100, 100);
	context2.restore();
}

// Show and hide sections
function showSection(sectionName) {
	//alert("In showSection()");

	if (document.getElementById(sectionName)) {
		document.getElementById(sectionName).style.display = "";
		document.getElementById(sectionName + "_sep").style.display = "";
	}
}

function hideSection(sectionName) {
	//alert("In hideSection()");

	if (document.getElementById(sectionName)) {
		document.getElementById(sectionName).style.display = "none";
		document.getElementById(sectionName + "_sep").style.display = "none";
	}
}

// Functions that deal with showing and hiding the Dashboard.
function onshow () {
	//alert("In onshow()");

	if (DMController) {
		DMController.dashboardActive = true;
	}
}

function onhide () {
	//alert("In onhide()");

	if (DMController) {
		DMController.dashboardActive = false;
	}
}

function onremove () {
	//alert("In onremove()");

	if (window.widget) {
		window.widget.setPreferenceForKey(null, createkey("cpu_enable"));
		window.widget.setPreferenceForKey(null, createkey("cpu_mode"));

		window.widget.setPreferenceForKey(null, createkey("mem_enable"));
		window.widget.setPreferenceForKey(null, createkey("mem_mode"));

		window.widget.setPreferenceForKey(null, createkey("net_enable"));
		window.widget.setPreferenceForKey(null, createkey("net_mode"));

		window.widget.setPreferenceForKey(null, createkey("disk_enable"));
		window.widget.setPreferenceForKey(null, createkey("disk_mode"));
	}
}



// Functions that deal with the preferences.
function showPrefs() {     
	//alert("In showPrefs()");

   document.getElementById('fliprollie').style.display = 'none';

	if (window.widget)         
		window.widget.prepareForTransition("ToBack");     

	if (window.widget) { // Restore the prefs.
		var tmp;

		tmp = parseInt(window.widget.preferenceForKey(createkey("cpu_mode")));
		if (tmp >= 0 && tmp < document.getElementById("cpu_mode").options.length) {
			document.getElementById("cpu_mode").options[tmp].selected = true;
		}

		tmp = parseInt(window.widget.preferenceForKey(createkey("mem_mode")));
		if (tmp >= 0 && tmp < document.getElementById("mem_mode").options.length) {
			document.getElementById("mem_mode").options[tmp].selected = true;
		}

		tmp = parseInt(window.widget.preferenceForKey(createkey("net_mode")));
		if (tmp >= 0 && tmp < document.getElementById("net_mode").options.length) {
			document.getElementById("net_mode").options[tmp].selected = true;
		}

		tmp = parseInt(window.widget.preferenceForKey(createkey("disk_mode")));
		if (tmp >= 0 && tmp < document.getElementById("disk_mode").options.length) {
			document.getElementById("disk_mode").options[tmp].selected = true;
		}


		tmp = window.widget.preferenceForKey(createkey("cpu_enable"));
		if (!tmp | tmp == "true") {
			document.getElementById("cpu_enable").checked = true;
		}
		else if (tmp == "false") {
			document.getElementById("cpu_enable").checked = false;
		}
		
		tmp = window.widget.preferenceForKey(createkey("mem_enable"));
		if (!tmp | tmp == "true") {
			document.getElementById("mem_enable").checked = true;
		}
		else if (tmp == "false") {
			document.getElementById("mem_enable").checked = false;
		}

		tmp = window.widget.preferenceForKey(createkey("net_enable"));
		if (!tmp | tmp == "true") {
			document.getElementById("net_enable").checked = true;
		}
		else if (tmp == "false") {
			document.getElementById("net_enable").checked = false;
		}

		tmp = window.widget.preferenceForKey(createkey("disk_enable"));
		if (!tmp | tmp == "true") {
			document.getElementById("disk_enable").checked = true;
		}
		else if (tmp == "false") {
			document.getElementById("disk_enable").checked = false;
		}
	}

	document.getElementById("front").style.display = "none";     
	document.getElementById("back").style.display = "block";     

	if (window.widget)         
		setTimeout ('widget.performTransition();', 0);   
} 

function hidePrefs() {     
	//alert("In hidePrefs()");

	savePrefs();

	// Hide reg.
	if (regDisplayed = 1) toggleReg();

	if (window.widget)         
		window.widget.prepareForTransition("ToFront");     

	document.getElementById("back").style.display = "none";     
	document.getElementById("front").style.display = "block";     

	if (window.widget)         
		setTimeout ('widget.performTransition();', 0); 
} 

function toggleReg() {
	//alert("In toggleReg()");
	if (regDisplayed == 0) {
		document.getElementById("reg_cell").style.display = "block";     
		document.getElementById("reg_separator").style.display = "block";     
		document.prefsForm.showRegButton.value = "Hide Registration";
		if (window.widget) {
			//alert("widget");
			if (DMController) {
				//alert("dmcontroller");
				if (DMController.snVal) {
					//alert("snVal" + DMController.snVal);
					document.regForm.serialNumber.value = window.widget.preferenceForKey("DMSerialNumber");
					document.getElementById('regString').innerHTML = "<span class='prefsLink'>Thank you for purchasing Dash Monitors!</span>";
					document.regForm.regButton.value = "Already Registered";
					//alert("final");
				}
				else {
					document.regForm.serialNumber.value = "";
					document.regForm.regButton.value = "Register";
				}	
			}
			else {
					document.regForm.serialNumber.value = "";
					document.regForm.regButton.value = "Register";
			}
		}
		regDisplayed = 1;
	}
	else {
		document.getElementById("reg_cell").style.display = "none";     
		document.getElementById("reg_separator").style.display = "none";     
		document.prefsForm.showRegButton.value = "Show Registration";
		regDisplayed = 0;
	}
}

function register() {
	//alert("In register()");
	registerGo(false);
}

function registerGo(toBack) {
	//alert("In registerGo()");
	if (window.widget) {
		var sn = window.widget.preferenceForKey("DMSerialNumber");
		
		if (DMController) {
			//alert("Got DMController");
			DMController.serialNumber = sn;

			if (DMController.allowUsage == true) {
				//alert("Allow usage = true");
				if (DMController.snVal) {
					document.getElementById('regString').innerHTML = "<span class='prefsLink'>Thank you for purchasing Dash Monitors!</span>";
				}
				else {
					if (regForm.serialNumber.value != "") {
						document.getElementById('regString').innerHTML = "<span class='prefsLink'>Invalid serial number.</span>";
					}
					else {
						document.getElementById('regString').innerHTML = "<span class='prefsLink' onClick=\"if (widget) widget.openURL('http://www.gauchosoft.com/DashMonitors/Buy/');\">Click here to purchase Dash Monitors.</span>";
					}
				}
			
				//alert("To back 1:  " + toBack);
				if (document.getElementById('back').style.display == "block" && toBack == true) {
					//alert("To back:  " + toBack);
					// This code works but does the flip.  The code below will work without the flip.
					//document.getElementById('back').style.display = "none";
					//document.getElementById('settings_separator').style.display = "";
					//document.getElementById('settings_cell').style.display = "";
					//document.getElementById('reg_separator').style.display = "";
					//document.getElementById('reg_cell').style.display = "";
					//showPrefs();
					

					document.getElementById('back').style.display = "none";
					document.getElementById('settings_separator').style.display = "";
					document.getElementById('settings_cell').style.display = "";
					document.getElementById('reg_separator').style.display = "";
					document.getElementById('reg_cell').style.display = "";
					document.getElementById('reg_separator').style.display = "";
					document.getElementById('reg_cell').style.display = "";

					// Code from showPrefs
					if (window.widget) { // Restore the prefs.
						var tmp;
				
						tmp = parseInt(window.widget.preferenceForKey(createkey("cpu_mode")));
						if (tmp >= 0 && tmp < document.getElementById("cpu_mode").options.length) {
							document.getElementById("cpu_mode").options[tmp].selected = true;
						}
				
						tmp = parseInt(window.widget.preferenceForKey(createkey("mem_mode")));
						if (tmp >= 0 && tmp < document.getElementById("mem_mode").options.length) {
							document.getElementById("mem_mode").options[tmp].selected = true;
						}
				
						tmp = parseInt(window.widget.preferenceForKey(createkey("net_mode")));
						if (tmp >= 0 && tmp < document.getElementById("net_mode").options.length) {
							document.getElementById("net_mode").options[tmp].selected = true;
						}
				
						tmp = parseInt(window.widget.preferenceForKey(createkey("disk_mode")));
						if (tmp >= 0 && tmp < document.getElementById("disk_mode").options.length) {
							document.getElementById("disk_mode").options[tmp].selected = true;
						}
				
				
						tmp = window.widget.preferenceForKey(createkey("cpu_enable"));
						if (!tmp | tmp == "true") {
							document.getElementById("cpu_enable").checked = true;
						}
						else if (tmp == "false") {
							document.getElementById("cpu_enable").checked = false;
						}
						
						tmp = window.widget.preferenceForKey(createkey("mem_enable"));
						if (!tmp | tmp == "true") {
							document.getElementById("mem_enable").checked = true;
						}
						else if (tmp == "false") {
							document.getElementById("mem_enable").checked = false;
						}
				
						tmp = window.widget.preferenceForKey(createkey("net_enable"));
						if (!tmp | tmp == "true") {
							document.getElementById("net_enable").checked = true;
						}
						else if (tmp == "false") {
							document.getElementById("net_enable").checked = false;
						}
				
						tmp = window.widget.preferenceForKey(createkey("disk_enable"));
						if (!tmp | tmp == "true") {
							document.getElementById("disk_enable").checked = true;
						}
						else if (tmp == "false") {
							document.getElementById("disk_enable").checked = false;
						}
					}
				
					document.getElementById("front").style.display = "none";     
					document.getElementById("back").style.display = "block";     
					// End of Code from showPrefs
				}
			}
			else {
				//alert("Allow usage = false");
				if (document.getElementById('back').style.display == "none") showPrefs();
				if (regDisplayed == 0) {
					toggleReg();
				}

				if (regForm.serialNumber.value != "") {
					document.getElementById('regString').innerHTML = "<span class='prefsLink'>Invalid serial number.</span>";
				}
				else {
					document.getElementById('regString').innerHTML = "<span class='prefsLink' onClick=\"if (widget) widget.openURL('http://www.gauchosoft.com/DashMonitors/Buy/');\">Your 30 day trial has expired, click here to purchase Dash Monitors.</span>";
				}

				document.getElementById('settings_cell').style.display = "none";
//				document.getElementById('settings_separator').style.display = "none";
			}
		}
		else {
			//alert("Didn't get DMController");
			/*
			if (document.getElementById('back').style.display != "none") showPrefs();
			if (!regDisplayed) {
				toggleReg();
			}

			document.getElementById('regString').innerHTML = "<span class='prefsLink' onClick=\"if (widget) widget.openURL('http://www.gauchosoft.com/DashMonitors/Buy/');\">Your 30 day trial has expired, click here to purchase Dash Monitors.</span>";

			document.getElementById('settings_separator').style.display = "none";
			document.getElementById('settings_cell').style.display = "none";
			*/
		}
	}
}

function setSerialNumber(sn) {
	//alert("In setSerialNumber()");
	if (window.widget) {
		window.widget.setPreferenceForKey(sn, "DMSerialNumber");
	}
}

function mousemove(event) {     
	if (!flipShown) {         
		if (animation.timer != null) {
			clearInterval(animation.timer);
			animation.timer = null;         
		}  
       
		var starttime = (new Date).getTime() - 13; 

		animation.duration = 500;
		animation.starttime = starttime;
		animation.firstElement = document.getElementById('flip');
		animation.timer = setInterval("animate();", 13);
		animation.from = animation.now;
		animation.to = 1.0;
		animate();
		flipShown = true;
	} 
} 

function mouseexit (event) {     
	if (flipShown) {
		// fade in the flip widget
		if (animation.timer != null) {
			clearInterval(animation.timer);
			animation.timer = null;
		}

		var starttime = (new Date).getTime() - 13;
		animation.duration = 500;
		animation.starttime = starttime;
		animation.firstElement = document.getElementById('flip');
		animation.timer = setInterval("animate();", 13);
		animation.from = animation.now;
		animation.to = 0.0;
		animate();
		flipShown = false;
	} 
} 

function enterflip(event) {
   document.getElementById('fliprollie').style.display = 'block';
}

function exitflip(event) {
   document.getElementById('fliprollie').style.display = 'none';
}

function animate() {     
	var T;
	var ease;
	var time = (new Date).getTime(); 

	T = limit_3(time-animation.starttime, 0, animation.duration);
	if (T >= animation.duration) {
		clearInterval(animation.timer);
		animation.timer = null;
		animation.now = animation.to;
	}
	else {
		ease = 0.5 - (0.5 * Math.cos(Math.PI * T / animation.duration));
		animation.now = computeNextFloat(animation.from, animation.to, ease);
	}     
	
	animation.firstElement.style.opacity = animation.now; 
} 

function limit_3 (a, b, c) {
	return a < b ? b : (a > c ? c : a); 
} 

function computeNextFloat (from, to, ease) {
	return from + (to - from) * ease; 
}

function createkey(key) {
	//alert("In createkey()");

	if (window.widget) {
		return window.widget.identifier + "-" + key;
	}
	else {
		return key;
	}
}
 
function noenter() {
	return !(window.event && window.event.keyCode == 13);
}
